<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 10/18/19
 * Time: 2:56 PM
 */

namespace App\Mails;

use App\System\User\Database\Models\User;
use Illuminate\Mail\Mailable;

class NewIsbnRequestPublisherMail extends Mailable
{
    /**
     * @var
     */
    public $isbnApp;
    /**
     * @var User
     */
    public $user;


    public function __construct($app, $user)
    {
        $this->isbnApp=$app;
        $this->user=$user;
    }

    public function build()
    {
        return $this->subject("New ISBN request application received.")
            ->view('emails.isbn-application-publisher')->with([
                'receiver'=> $this->user->first_name,
                'title' => "New ISBN request application received",
                'application' => $this->isbnApp
            ])->to($this->user->email);
    }
}
