<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 10/18/19
 * Time: 2:56 PM
 */

namespace App\Mails;

use Illuminate\Mail\Mailable;
use Illuminate\Routing\Route;

class IsbnRequestAdminMail extends Mailable
{
    /**
     * @var
     */
    public $isbnApp;
    /**
     * @var
     */
    public $user;

    protected $updateMail = false;


    public function __construct($app, $user)
    {
        $this->isbnApp=$app;
        $this->user=$user;
    }

    public function setIsUpdateMail ($bool = false ) {
        $this->updateMail = $bool;
    }

    public function build()
    {
        $this->isbnApp->load('authors');
        return $this->subject($this->updateMail === false ? "New ISBN request application." : "Isbn application updated.")
            ->view('emails.isbn-application-admin')->with([
                'receiver'=>"ISBN Officer",
                'title' => $this->updateMail === false ?  "New ISBN request application" : "Isbn application updated.",
                'application' => $this->isbnApp,
                'url' => \route('manage.isbn-applications.show',['id'=>$this->isbnApp->id]),
                'new' => !$this->updateMail
            ])->to($this->user->email);
    }
}
