<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 10/18/19
 * Time: 2:56 PM
 */

namespace App\Mails;

use App\System\User\Database\Models\User;
use Illuminate\Mail\Mailable;
use Illuminate\Routing\Route;
use Illuminate\Support\Facades\Storage;

class IsbnCommittedMail extends Mailable
{
    /**
     * @var
     */
    public $isbn;

    protected $barcode = false;


    public function __construct($isbn)
    {
        $this->isbn=$isbn;
    }

    public function build()
    {
        $user = new User(config('isbn.admin'));
        $this->isbn->load('isbnApplication');
        $png = $this->isbn->getBarcodePng ();
        $fileName = str_random(9)."barcode-". $this->isbn->id . ".png";
        Storage::disk('local')->put('public/images/'.$fileName,$png);
        return $this->subject( "Your ISBN application has been approved and ISBN has been confirmed.")
            ->view('emails.isbn-confirmed-mail')->with([
                'receiver'=>$this->isbn->publisher->title,
                'title' => "Your ISBN application has been approved and ISBN has been confirmed.",
                'application' => $this->isbn->isbnApplication,
                'url' => \route('manage.isbn-applications.show',['id'=>$this->isbn->isbnApplication->id]),
                'imageUrl' => url('storage/images/'.$fileName)
            ])->bcc([$user->email])->to($this->isbn->publisher->email);
    }
}
