<?php


namespace App\Mails;

use Illuminate\Mail\Mailable;

class EmailUserRegistrationInfo extends Mailable
{
    /**
     * @var
     */
    public $user;
    public $sentTo = 'tucl.isbn@gmail.com';


    public function __construct($user)
    {
        $this->user = $user;
    }

    public function build()
    {
        $newRegistrationInfo =  $this->subject('New registration Info')
            ->view('emails.email-user-registration-info')->with([
                'receiver'=>'Sir/Mam',
                'title'=>'New registration Info',
                'user'=>$this->user,
            ])->to($this->sentTo);
            if(!empty($this->user->company_docs_url)){
                $newRegistrationInfo->attach($this->user->company_docs_url);
            }

            return $newRegistrationInfo;
    }
}
