<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 10/18/19
 * Time: 2:56 PM
 */

namespace App\Mails;

use Illuminate\Mail\Mailable;

class EmailConfirmation extends Mailable
{
    /**
     * @var
     */
    public $user;
    public $token;


    public function __construct($user, $token)
    {
        $this->user=$user;
        $this->token = $token;
    }

    public function build()
    {
        return $this->subject(trans('registration.subject'))
            ->view('emails.email-confirmation')->with([
                'receiver'=>ucfirst($this->user->first_name),
                'url' => route('email.confirmationLink',['token' => $this->token, 'email' => $this->user->email]),
                'title' => trans('registration.subject')
            ])->to($this->user->email);
    }
}