<?php
/**
 * Created by PhpStorm.
 * User: nicore
 * Date: 10/17/19
 * Time: 10:24 PM
 */

namespace App\Listeners;



use App\Mails\EmailConfirmation;
use App\Mails\EmailUserRegistrationInfo;
use Illuminate\Auth\Events\Registered;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Str;

class UserEventSubscriber
{
    public function onUserRegistered (Registered $registered) {
        $token = Str::random();
        DB::table('user_registration_confirmation')
            ->insert([
                'email' => $registered->user->email,
                'token' => $token,
                'created_at' => new Carbon(),
            ]);
        try {
		Mail::send(new EmailConfirmation($registered->user, $token));
		Mail::send(new EmailUserRegistrationInfo($registered->user));
        } catch (\Exception $exception) {

        }
    }

    public function subscribe ($event) {
        $event->listen(Registered::class, UserEventSubscriber::class . '@onUserRegistered');
    }
}
