<?php


namespace App\Listeners;


use App\Events\Publisher\Deleting;
use App\Events\Publisher\PrefixDeleting;
use App\Events\Publisher\PublisherAdminAssignment;
use App\Mails\PublisherAdminAssignmentMail;
use Illuminate\Support\Facades\Mail;
use NicoSystem\Exceptions\ResourceInUseException;

class PublisherEventSubscriber
{

    public function onDeletingPublisher(Deleting $deleting) {
        if($deleting->getPublisher()->isbnApplications()->count() > 0) {
            throw new ResourceInUseException();
        }
    }
    public function onDeletingPublisherPrefix(PrefixDeleting $deleting) {
        if($deleting->getPrefix()->issuedIsbns()->count() > 0) {
            throw new ResourceInUseException();
        }
    }

    public function onPublisherAdminAssignment (PublisherAdminAssignment $event) {
        try {
            Mail::send(new PublisherAdminAssignmentMail($event->getPublisher(), $event->getUser()));
        } catch (\Exception $exception) {

        }

    }

    /**
     * @param $events
     */
    public function subscribe($events)
    {
        $events->listen(Deleting::class, PublisherEventSubscriber::class . '@onDeletingPublisher');
        $events->listen(PrefixDeleting::class, PublisherEventSubscriber::class . '@onDeletingPublisherPrefix');
        $events->listen(PublisherAdminAssignment::class, PublisherEventSubscriber::class . '@onPublisherAdminAssignment');
    }
}
