<?php


namespace App\Listeners;


use App\Events\Job\JobEnded;
use App\Events\Job\JobFailed;
use App\Events\Job\JobStarted;
use App\System\Job\Databases\JobLog;

/**
 * Class JobEventSubscriber
 * @package App\Listeners
 */
class JobEventSubscriber
{
    /**
     * @param JobStarted $event
     */
    public function onJobStarted(JobStarted $event)
    {
        $this->removeOldFailedLog($event);
        $jobLog = new JobLog();
        $jobLog->resource = $event->resource;
        $jobLog->resource_id = $event->resourceId;
        $jobLog->job_start_at = now();
        $jobLog->save();
    }

    /**
     * @param JobEnded $event
     */
    public function onJobEnded(JobEnded $event)
    {
        JobLog::where('resource',$event->resource)
            ->where('resource_id',$event->resourceId)
            ->whereNull('job_failed_at')->delete();
    }

    /**
     * before processing for new job we need to
     * clear old instance of failed job log
     * @param $event
     */
    private function removeOldFailedLog($event)
    {
        JobLog::where('resource',$event->resource)
            ->where('resource_id',$event->resourceId)
            ->whereNotNull('job_failed_at')->delete();
    }

    /**
     * @param JobFailed $event
     */
    public function onJobFailed(JobFailed $event)
    {
        $jobLog = JobLog::where('resource',$event->resource)
            ->where('resource_id',$event->resourceId)
            ->whereNull('job_failed_at')->first();
        $jobLog->job_failed_at = now();
        $jobLog->save();
    }

    /**
     * @param $events
     */
    public function subscribe($events)
    {
        $events -> listen(JobStarted::class, JobEventSubscriber::class . '@onJobStarted');
        $events -> listen(JobEnded::class, JobEventSubscriber::class . '@onJobEnded');
        $events -> listen(JobFailed::class, JobEventSubscriber::class . '@onJobFailed');
    }
}