<?php


namespace App\Listeners;


use App\Events\IsbnApplication\Created;
use App\Events\IsbnApplication\IsbnIssuedCommitted;
use App\Events\IsbnApplication\Updated;
use App\Mails\IsbnCommittedMail;
use App\Mails\IsbnRequestAdminMail;
use App\Mails\NewIsbnRequestPublisherMail;
use App\System\User\Database\Models\User;
use Illuminate\Support\Facades\Mail;
use Picqer\Barcode\BarcodeGeneratorPNG;
use Picqer\Barcode\Exceptions\BarcodeException;

class IsbnApplicationEventSubscriber
{

    public function onApplicationCreated(Created $created) {
        $user = new User(config('isbn.admin'));
        try {
            Mail::send(new IsbnRequestAdminMail($created->getModel(), $user));
            if($created->getUser()) {
                Mail::send(new NewIsbnRequestPublisherMail($created->getModel(), $created->getUser()));
            }
        } catch (\Exception $exception) {

        }

    }

    public function onApplicationUpdated(Updated $updated) {
        $user = new User(config('isbn.admin'));
        try {
            $mail = new IsbnRequestAdminMail($updated->getModel(), $user);
            $mail ->setIsUpdateMail(true);
            Mail::send($mail);
        }catch (\Exception $exception) {

        }
    }

    public function onIsbnIssueCommitted (IsbnIssuedCommitted $event) {
        $isbn = $event->getModel();
        try {
            Mail::send(new IsbnCommittedMail($isbn));
        }
        catch (\Exception $exception) {
        }
    }

    /**
     * @param $events
     */
    public function subscribe($events)
    {
        $events->listen(Created::class, IsbnApplicationEventSubscriber::class . '@onApplicationCreated');
        $events->listen(Updated::class, IsbnApplicationEventSubscriber::class . '@onApplicationUpdated');
        $events->listen(IsbnIssuedCommitted::class, IsbnApplicationEventSubscriber::class . '@onIsbnIssueCommitted');
    }
}
