<?php


namespace App\Listeners;


use App\Events\File\FileMove;
use App\System\Foundation\FileUpload\Upload;

class FileEventSubscriber
{
    use Upload;

    /**
     * @param FileMove $event
     */
    public function onFileMoved(FileMove $event)
    {
        $path = $this->moveFromTemp($event->sourceFile);
        $event->model->{$event->field}=$path;
        $event->model->save();
    }

    /**
     * @param $events
     */
    public function subscribe($events)
    {
        $events->listen(FileMove::class, FileEventSubscriber::class . '@onFileMoved');
    }
}