<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use NicoSystem\Requests\NicoRequest;

class UserChangePasswordRequest extends NicoRequest
{
    public function rules()
    {
        return [
            'old_password'=>'required|string',
            'new_password'=>'required|min:8|string|confirmed',
        ];
    }

    /**
     * Configure the validator instance.
     *
     * @param  \Illuminate\Validation\Validator  $validator
     * @return void
     */
    public function withValidator($validator)
    {
        $validator->after(function ($validator) {
            //check old password match or not
            if ($this->has('old_password') && !Hash::check($this->old_password, Auth::user()->password)) {

                $validator->errors()->add('old_password', trans('user.old_password'));
            }

            //check new password and old password are same or not
            if($this->has('new_password') && $this->old_password===$this->new_password)
            {
                $validator->errors()->add('new_password', trans('user.recent_password'));
            }
        });
    }
}
