<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 12/28/18
 * Time: 2:20 PM
 */

namespace App\Http\Middleware;


use App\Exceptions\SiteTokenMisMatchException;
use App\System\Site\Database\Models\Site;
use Illuminate\Http\Request;
use Laravel\Passport\Token;

class VerifySiteToken
{
    /**
     * @param Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle ( Request $request, \Closure $next) {
        $siteParam= $request->route('site');

        $site=$this->getSite($siteParam);
        if(!$this->verifyToken($request->header('authorization'),$site->id))
        {
            throw new SiteTokenMisMatchException();
        }
        return $next ($request);
    }

    /**
     * @param $siteParam
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Model
     */
    protected function getSite($siteParam){
        $site=Site::query();
        if(is_numeric($siteParam))
        {
            $site->whereId($siteParam);
        }
        elseif (is_string($siteParam))
        {
            $site->whereDomain($siteParam);
        }
        return $site->firstOrFail();
    }

    /**
     * @param $token
     * @param $site_id
     * @return bool
     */
    private function verifyToken($token,$site_id)
    {
        $jwt = trim(preg_replace('/^(?:\s+)?Bearer\s/', '', $token));
        $token = (new \Lcobucci\JWT\Parser())->parse($jwt);

        $token_id=$token->getClaim('jti');

        $token=Token::find($token_id);

        return in_array($site_id,$token->scopes);
    }

}