<?php
/**
 * Created by PhpStorm.
 * User: rocco
 * Date: 12/28/18
 * Time: 5:35 PM
 */

namespace App\Http\Middleware;


use App\System\AppConstants;
use App\System\Site\Database\Models\Site;
use Illuminate\Http\Request;
use NicoSystem\Exceptions\NicoAuthenticationException;

class ReturnifSiteProtected
{
    /**
     * @param Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle ( Request $request, \Closure $next) {
        $siteParam= $request->route('site');

        $site=$this->getSite($siteParam);
        if($site->password)
        {
            throw new NicoAuthenticationException('Site is password Protected',AppConstants::ERR_PROTECTED_SITE);
        }
        return $next ($request);
    }

    /**
     * @param $siteParam
     * @return \Illuminate\Database\Eloquent\Builder|\Illuminate\Database\Eloquent\Model
     */
    protected function getSite($siteParam){
        $site=Site::query();
        if(is_numeric($siteParam))
        {
            $site->whereId($siteParam);
        }
        elseif (is_string($siteParam))
        {
            $site->whereDomain($siteParam);
        }
        return $site->firstOrFail();
    }
}