<?php


namespace App\Http\Middleware;


use App\System\AppConstants;
use App\System\User\Database\Models\ActiveUser;
use Closure;
use Illuminate\Http\Request;
use Laravel\Passport\Token;

class ReplaceImpersonateUser
{
    public function handle ( Request $request, Closure $next) {

        $token=$request->header('authorization');

        $jwt = trim(preg_replace('/^(?:\s+)?Bearer\s/', '', $token));
        $token = (new \Lcobucci\JWT\Parser())->parse($jwt);

        $token_id=$token->getClaim('jti');

        $token=Token::find($token_id);

        $scope=$token->scopes;

        if(count($scope)>0)
        {
            AppConstants::getInstance()->setIsImpersonateUser(true);

            if($request->route()->uri()!=='api/domains')
            {
                $user=ActiveUser::find($scope[0]);
                app('auth')->guard('api')->setUser($user);

                app('auth')->shouldUse('api');
            }

        }
        return $next ($request);
    }
}