<?php

namespace App\Http;

use App\Http\Middleware\NicoAuth;
use App\Http\Middleware\PasswordUpdated;
use App\Http\Middleware\RedirectIfAuthenticated;
use App\Http\Middleware\ReturnifSiteProtected;
use App\Http\Middleware\SecureConnectionRedirect;
use App\Http\Middleware\VerifySiteToken;
use App\Http\Middleware\AddAccessTokenMiddleware;
use Barryvdh\Cors\HandleCors;
use Illuminate\Foundation\Http\Kernel as HttpKernel;
use Laravel\Passport\Http\Middleware\CheckClientCredentials;

class Kernel extends HttpKernel
{
    /**
     * The application's global HTTP middleware stack.
     *
     * These middleware are run during every request to your application.
     *
     * @var array
     */
    protected $middleware = [
        \Illuminate\Foundation\Http\Middleware\CheckForMaintenanceMode::class,
        \Illuminate\Foundation\Http\Middleware\ValidatePostSize::class,
        \App\Http\Middleware\TrimStrings::class,
        \Illuminate\Foundation\Http\Middleware\ConvertEmptyStringsToNull::class,
        \App\Http\Middleware\TrustProxies::class,
        HandleCors::class,
        AddAccessTokenMiddleware::class,
    ];

    /**
     * The application's route middleware groups.
     *
     * @var array
     */
    protected $middlewareGroups = [
        'web' => [
            \App\Http\Middleware\EncryptCookies::class,
            \Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse::class,
            \Illuminate\Session\Middleware\StartSession::class,
            \Illuminate\View\Middleware\ShareErrorsFromSession::class,
            \App\Http\Middleware\VerifyCsrfToken::class,
            \Illuminate\Routing\Middleware\SubstituteBindings::class,
        ],

        'api' => [
            'throttle:1000,1',
            'bindings',
        ],
        'authApi' => [
            'auth', 'throttle:1000,1', 'bindings', 'passwordUpdated'
        ]
    ];

    /**
     * The application's route middleware.
     *
     * These middleware may be assigned to groups or used individually.
     *
     * @var array
     */
    protected $routeMiddleware = [
        'addAccessToken'=>AddAccessTokenMiddleware::class,
        'auth' => \Illuminate\Auth\Middleware\Authenticate::class,
        'auth.basic' => \Illuminate\Auth\Middleware\AuthenticateWithBasicAuth::class,
        'bindings' => \Illuminate\Routing\Middleware\SubstituteBindings::class,
        'cache.headers' => \Illuminate\Http\Middleware\SetCacheHeaders::class,
        'can' => \Illuminate\Auth\Middleware\Authorize::class,
        'guest' => RedirectIfAuthenticated::class,
        'signed' => \Illuminate\Routing\Middleware\ValidateSignature::class,
        'throttle' => \Illuminate\Routing\Middleware\ThrottleRequests::class,
        'passwordUpdated' => PasswordUpdated::class,
        'nicoAuth' => NicoAuth::class,
        'client' => CheckClientCredentials::class,
        'verifySiteToken' => VerifySiteToken::class,
        'passwordProtection' => ReturnifSiteProtected::class,
        'secureConnection' => SecureConnectionRedirect::class
    ];
}
