<?php


namespace App\Http\Controllers;


use App\System\Site\Database\Models\SiteTemplate;
use GuzzleHttp\Client;
use Illuminate\Http\Request;

class FileController extends Controller
{
    /**
     * @param Request $request
     * @param $templateName
     * @param $folder
     * @param $fileName
     * @return string
     */
    public function file(Request $request, $templateName, $folder, $fileName)
    {
        $baseUrl = $this->getUrl($templateName);
        $url = $baseUrl."/assets/".$folder."/".$fileName;
        $client = new Client();
        $response = $client->get($url);
        $headers = collect($response->getHeaders())
            ->mapWithKeys(function ($value,$key){
            return [$key=>$value[0]];
        })->toArray();
        $content=  $response->getBody()->getContents();
        return response($content,$response->getStatusCode(),$headers);
    }

}
