<?php

namespace App\Http\Controllers;

use App\System\Foundation\FileUpload\Upload;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Illuminate\Http\Request;
use NicoSystem\Controllers\BaseController;

class Controller extends BaseController
{
    use Upload;

    /**
     * @param Request $request
     * @return mixed
     * @throws \Illuminate\Validation\ValidationException
     */
    public function uploadResources(Request $request){
        $this->validate($request,['file'=>'required','type'=>"required|in:image,document,image_doc,video"]);
        $rule = "required";

        switch ($request->get('type')){
            case "image":
                $rule="required|mimes:jpg,png,jpeg";
                break;
            case "document":
                $rule="required|mimes:pdf,docx,doc";
                break;
            case "image_doc":
                $rule="required|mimes:jpg,png,jpeg,pdf,docx,doc";
                break;
            case "video":
                $rule="required|mimes:mp4";
                break;

        }
        $this->validate($request,['file'=>$rule]);


        $result = $this->upload($request);
        return $this->responseOk($result);
    }

    /**
     * @param Request $request
     * @return mixed
     */
    public function uploadTemplateFile(Request $request)
    {
        $this->validate($request,['file.*'=>'required']);
        $files=$request->file('file');
        $folder = str_random(8);
        $result='';
        foreach ($files as $file)
        {
            $result = $this->uploadTemplate($file,$folder);
        }
        return $this->responseOk($result);
    }
}
