<?php

namespace App\Http\Controllers\Auth;

use App\System\User\Database\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use NicoSystem\Controllers\BaseController;
use NicoSystem\Data\Status;
use NicoSystem\Exceptions\NicoBadRequestException;
use ReCaptcha\ReCaptcha;

class RegisterController extends BaseController
{


    public function __construct() // TODO: implement OAuth for registration
    {
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'first_name' => 'required|max:255',
            'last_name' =>'required|max:255',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|min:6|confirmed',
        ]);
    }

    protected function verifyReCaptchaOrFail (Request $request) {
        $token = $request->get('recaptcha_token');
        $recaptcha = new ReCaptcha(config('recaptcha.api_secret_key'));
        $recaptcha = $recaptcha->setExpectedHostname(config('recaptcha.web_app_host'));
        $response = $recaptcha->verify($token);
        if(!$response->isSuccess()) {
            throw new NicoBadRequestException("Oops!! We cannot verify if you're a human or a robot.", "Oops! cannot verify if you're a human or a robot.");
        }
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  Request  $request
     * @return mixed
     */
    public function create(Request $request)
    {
        $this->verifyReCaptchaOrFail($request);
        $validator = $this->validator($request->all());
        if($validator->fails()) {
            return $this->responseValidationError($validator->getMessageBag());
        }
        $user = new User();
        $user ->fill($request->all());
        $user -> is_locked = User::STATUS_LOCKED;
        $user -> password = bcrypt($request->get('password'));
        $user -> status = Status::STATUS_PUBLISHED;
        $user -> save ();
        event(new Registered($user));
        return $this->responseOk(null);

    }

    public function confirmEmail (Request $request) {
        $email = $request->get('email');
        $token = $request->get('token');

        $row  = DB::table('user_registration_confirmation')
            ->where('email',$email)
            ->where('token',$token)
            ->first();
        if(!$row) {
            $route = route('frontend.login',['email-confirmation-error' => 1]);
        }else {
            $route = route('frontend.login',['email-confirmation-error'=>0]);
            $user = User::where('email',$email)->first();
            $user -> is_locked = User::STATUS_UNLOCKED;
            $user->save();
        }
        return Redirect::to($route);
    }
}
