<?php

namespace App\Http\Controllers\Auth;

use App\System\User\Database\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use NicoSystem\Controllers\BaseController;
use NicoSystem\Data\Status;
use NicoSystem\Exceptions\NicoBadRequestException;
use ReCaptcha\ReCaptcha;
use App\System\Foundation\FileUpload\Upload;

class RegisterController extends BaseController
{
    use Upload;

    public function __construct() // TODO: implement OAuth for registration
    {
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'first_name' => 'required|max:255',
            'last_name' =>'required|max:255',
            'address_of_publisher' =>'required|max:255',
            'name_of_publisher' =>'required|max:255',
            'contact_number' =>'required|max:255',
            'register_type' =>'required|max:255',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|min:6|confirmed',
         //   'company_docs_url' => 'required|max:191'
        ]);
    }

    protected function verifyReCaptchaOrFail (Request $request) {
	    $token = $request->get('recaptcha_token');
        $recaptcha = new ReCaptcha(config('recaptcha.api_secret_key'));
        $recaptcha = $recaptcha->setExpectedHostname(config('recaptcha.web_app_host'));
	$response = $recaptcha->verify($token);
        if(!$response->isSuccess()) {
            throw new NicoBadRequestException("Oops!! We cannot verify if you're a human or a robot.", "Oops! cannot verify if you're a human or a robot.");
        }
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  Request  $request
     * @return mixed
     */
    public function create(Request $request)
    {
        $this->verifyReCaptchaOrFail($request);
        $validator = $this->validator($request->all());
        if($validator->fails()) {
            return $this->responseValidationError($validator->getMessageBag());
	
	}	
        $user = new User();
        $user ->fill($request->all());
        $user -> is_locked = User::STATUS_LOCKED;
        $user -> password = bcrypt($request->get('password'));
        $user -> status = Status::STATUS_PUBLISHED;
        $user -> save ();
        event(new Registered($user));
        return $this->responseOk(null);

    }

    public function confirmEmail (Request $request) {
        $email = $request->get('email');
        $token = $request->get('token');

        $row  = DB::table('user_registration_confirmation')
            ->where('email',$email)
            ->where('token',$token)
            ->first();
        if(!$row) {
            $route = route('frontend.login',['email-confirmation-error' => 1]);
        }else {
            $route = route('frontend.login',['email-confirmation-error'=>0]);
            $user = User::where('email',$email)->first();
            $user -> is_locked = User::STATUS_UNLOCKED;
            $user->save();
        }
        return Redirect::to($route);
    }

    /**
     * @param Request $request
     * @return mixed
     * @throws \Illuminate\Validation\ValidationException
     */
    public function uploadResources(Request $request){
        $this->validate($request,['file'=>'required','type'=>"required|in:image,document,image_doc,video"]);
        $rule = "required";

        switch ($request->get('type')){
            case "image":
                $rule="required|mimes:jpg,png,jpeg";
                break;
            case "document":
                $rule="required|mimes:pdf,docx,doc";
                break;
            case "image_doc":
                $rule="required|mimes:jpg,png,jpeg,pdf,docx,doc";
                break;
            case "video":
                $rule="required|mimes:mp4";
                break;

        }
        $this->validate($request,['file'=>$rule]);


        $result = $this->upload($request);
        return $this->responseOk($result);
    }
}
