<?php
    /**
     * Created by PhpStorm.
     * User: Amar
     * Date: 10/23/2017
     * Time: 6:27 PM
     */

    namespace App\Http\Controllers\Auth;


    use App\Exceptions\OldPasswordMismatchException;
    use Illuminate\Http\Request;
    use Illuminate\Support\Facades\Auth;
    use Illuminate\Support\Facades\Hash;
    use NicoSystem\Controllers\BaseController;

    class PasswordController extends BaseController
    {
        /**
         * @var \Illuminate\Contracts\Auth\Authenticatable
         */
        protected $authUser = null;

        /**
         * PasswordController constructor.
         *
         * @param Auth $auth
         */
        public function __construct(Auth $auth)
        {
            $this->authUser = $auth->user();
        }

        /**
         * @param Request $request
         *
         * @return mixed
         */
        public function updatePassword(Request $request){
            //this method will reside under auth:api middleware, therefore we don't need to check if user is null or not
            //Auth::user() is always going to return an object
            $this->validate($request,$this->getRules());

            $this->confirmOldPasswordIsCorrect($request);

            $this->authUser->password = bcrypt($request->get('password'));
            $this->authUser->is_locked = 0;
            $this->authUser->save();

            return $this->responseOk(null);

        }

        /**
         * Confirm if the old password is correct
         * @param Request $request
         * @throws OldPasswordMismatchException
         */
        protected function confirmOldPasswordIsCorrect(Request $request){
            if(!Hash::check($request->get('old_password'),$this->authUser->password)){
                throw  new OldPasswordMismatchException();
            }
        }
        protected function getRules(){
            return [
                'old_password'=>'required',
                'password'=>'required|confirmed|password',
            ];
        }

    }