<?php
    /**
     * Created by PhpStorm.
     * User: Amar
     * Date: 11/2/2017
     * Time: 1:16 PM
     */

    namespace App\Http\Controllers;


    use App\System\Site\Database\Models\Site;
    use Illuminate\Http\Request;
    use Illuminate\Routing\Route;
    use Illuminate\Support\Facades\App;
    use Illuminate\Support\Facades\File;
    use Illuminate\Support\Facades\Redirect;

    /**
     * Class AngularAppController
     *
     * @package App\Http\Controllers
     */
    class AngularAppController extends Controller
    {
        /**
         * @var \Illuminate\Config\Repository|mixed|string
         */
        protected $schemeParameter = "";
        /**
         * @var \Illuminate\Config\Repository|mixed|string
         */
        protected $schemeParamTrueValue="";

        protected $contents = "";



        /**
         * AngularAppController constructor.
         */
        public function __construct()
        {
            $this->schemeParameter = config('app.app_scheme_check_parameter');
            $this->schemeParamTrueValue=config('app.app_scheme_check_parameter_true_value',false);
            try {
                $this->contents = file_get_contents(public_path('index.html'));
            }catch (\Exception $exception){
                App::abort(404);
            }
        }

        /**
         * @return array
         */
        public function getSettings(Request $request){
            $currentUrl = \Illuminate\Support\Facades\URL::current();
            $queries = $request->except($this->schemeParameter);
            $urlWithoutSchemeUrl= $currentUrl."?".http_build_query($queries);
            return  [
                '##redirectUrl##'=>$urlWithoutSchemeUrl,
                '##timeoutValue##'=>config('app.app_scheme_redirect_timeout'),
                '##schemeUrl##'=>preg_replace('/http(s)?:\/\//',config('app.app_scheme'),$urlWithoutSchemeUrl),
            ];
        }

        /**
         * @param Request $request
         *
         * @return bool
         */
        protected function attachSchemeUrl(Request $request){
            return config('app.enable_scheme_definition') && $request->get($this->schemeParameter)==$this->schemeParamTrueValue /*&&( strpos(strtolower($request->header('user-agent')),'mobile'))*/;
        }

        /**
         * @param Request $request
         *
         * @return mixed|string
         */
        public function index(Request $request, $domain = null){

            if($this->attachSchemeUrl($request)){
                //url without scheme enabling parameter
                $settings = $this->getSettings($request);
                $scheme = file_get_contents(config('app.app_scheme_definition_location'));
                foreach($settings as  $search=>$replace){
                    $scheme = str_replace($search,$replace,$scheme);
                }

                //replace the string from $contents
                $this->contents = str_replace("<!--####SchemaDefinition####-->",$scheme,$this->contents);
            }

            return $this->contents;
        }

        /**
         * @return mixed
         */
        public function dashboard() {//TODO Temporary method. WIll be removed after dashboard has been set up
            return $this->responseOk('');
        }
    }
