<?php
return [
    'buckets' => [
        'table' => 'buckets',
        'column' => [
            'id' => 'id',
            'title' => 'title',
            'description' => 'description',
            'status' => 'status',
        ]
    ],
    'bucket_video' => [
        'table' => 'video_bucket',
        'column' => [
            'bucket_id' => 'bucket_id',
            'video_id' => 'video_id',
            'order' => 'order'
        ]
    ],
    'categories' => [
        'table' => 'categories',
        'column' => [
            'id' => 'id',
            'main' => 'title',
            'site_id' => 'site_id',
            'order' => 'order'
        ]
    ],
    'html5calculators' => [
        'table' => 'calculators',
        'column' => [
            'id' => 'id',
            'title' => 'title',
            'description' => 'description',
            'link' => 'url',
            'status'=>'status'
        ]
    ],
    'links' => [
        'table' => 'links',
        'column' => [
            'title' => 'title',
            'link' => 'url',
            'status' => 'status',
            'category_id' => 'category_id',
        ]
    ],
    'resources' => [
        'table' => 'documents',
        'column' => [
            'title' => 'title',
            'description' => 'description',
            'status' => 'status',
            'resource_url' => 'url',
            'category_id' => 'category_id',
        ]
    ],
    'site_contacts' => [
        'table' => 'contacts',
        'column' => [
            'title' => 'title',
            'content' => 'value',
            'contact_type' => 'type',
            'status'=>'status',
            'category_id' => 'category_id',
            'description' => 'description',
        ]
    ],
    'site_html5calculator'=> [
        'table'=>'category_calculators',
        'column'=> [
            'html5calculator_id'=>'calculator_id',
            'order' => 'order',
            'site_id' => 'category_id',
        ]
    ],
    'sites'=>[
        'table'=>'sites',
        'column'=>[
            'id'=>'id',
            'title'=>'title',
            'domain'=>'domain',
            'description'=>'description',
            'logo_url'=>'logo_url',
            'primary_color'=>'primary_color',
            'secondary_color'=>'secondary_color',
            'status'=>'status',
            'message'=>'message'
        ]
    ],
    'site_video'=>[
        'table'=>'site_videos',
        'column'=>[
            'site_id'=>'site_id',
            'video_id'=>'video_id',
            'order'=>'order'
        ]
    ],
    'site_bucket'=>[
        'table'=>'site_buckets',
        'column'=>[
            'site_id'=>'site_id',
            'bucket_id'=>'bucket_id',
        ]
    ],
    'users'=>[
        'table'=>'users',
        'column'=>[
            'id'=>'id',
            'username'=>'username',
            'password'=>'password',
            'email'=>'email',
            'remember_token'=>'remember_token',
            'status'=>'status'
        ]
    ],
    'videos'=>[
        'table'=>'vidoes',
        'column'=>[
            'id'=>'id',
            'title'=>'title',
            'description'=>'description',
            'author'=>'author',
            'duration'=>'duration',
            'size'=>'size',
            'video_url'=>'video_url',
            'poster_url'=>'video_thumbnail_url',
            'status'=>'status'
        ]
    ]
];