<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 12/29/2016
 * Time: 10:11 PM
 */

    /**
     * Determines if the coming request is an api call or not
     * @param \Illuminate\Http\Request $request
     *
     * @return bool
     */
function is_api_request(\Illuminate\Http\Request $request){
    return $request->segment(1)=='api';
}

function turn_to_app_constant_format($string){
    //replace all the special characters with underscore
    return preg_replace("/[^a-zA-Z0-9]/",'_',$string);

}

    /**
     * @param $url
     *
     * @return string
     */
function get_thumb_url($url){
    $arr = explode('.',$url);
    $extension = array_pop($arr);
    $name = implode('.',$arr);
    $name .=config('fileupload.thumb_suffix').".".$extension;
    return $name;
}

    /**
     * @return string
     */
function get_scheme_route_query_parameter(){
    return config('app.app_scheme_check_parameter')."=".config('app.app_scheme_check_parameter_true_value');
}

function get_isbn_number($countryFixedPrefix, $publisherPrefix, $isbnNumber) {
    $countryFixedPrefix = str_replace('-','', $countryFixedPrefix);

    if (!is_numeric($countryFixedPrefix)) {
        throw new RuntimeException("Invalid country prefix.");
    }
    if (!is_numeric($publisherPrefix)) {
        throw new RuntimeException('Invalid publisher prefix. All the digits must be numeric');
    }
    if (!is_numeric($isbnNumber)) {
        throw new RuntimeException('Invalid ISBN title value. All the digits must be numeric');
    }

    $combinedIsbnNumber = $countryFixedPrefix.$publisherPrefix.$isbnNumber;
    $remainingDigits = 12 - strlen($combinedIsbnNumber);
    if ($remainingDigits < 0) {
        throw new RuntimeException('Invalid isbn number');
    }
    for ( $i = 0; $i < $remainingDigits; $i++ ) {
        $isbnNumber = "0".$isbnNumber;
    }
    return $countryFixedPrefix.$publisherPrefix.$isbnNumber;
}

function get_isbn_mdd_13_digit ($isbnNumber) {
    if(strlen($isbnNumber) !== 12 || !is_numeric($isbnNumber)) {
        throw  new RuntimeException("Invalid isbn number");
    }
    $sum = 0;
    for ($i = 0; $i < strlen($isbnNumber); $i++) {
        if ($i % 2 === 0) {
            $sum += $isbnNumber[$i];
        } else {
            $sum += $isbnNumber[$i] * 3;
        }
    }
    $mod = 10 - ($sum % 10);
    if($mod == 10) {
        return 0;
    }
    return $mod;

  }
