<?php

namespace App\Console\Commands;

use Carbon\Carbon;
use Illuminate\Console\Command;
use Illuminate\Database\ConnectionInterface;
use Illuminate\Support\Facades\DB;

class MigrateOldDatabase extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'migrateOldDatabase';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'migrate old database';
    /**
     * @var ConnectionInterface
     */
    protected $fromDbConnection;
    /**
     * @var ConnectionInterface
     */
    protected $toDbConnection;

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    protected function makeDbConnect ($fromDb, $toDB) {
        $config = config('database.connections.mysql');

        $config['database'] = $fromDb;
        config()->set('database.connections.fromDB',$config);
        $this->fromDbConnection = DB::connection('fromDB');

        $config['database'] = $toDB;
        config()->set('database.connections.toDB',$config);
        $this->toDbConnection = DB::connection('toDB');

    }

    public function migrateUsers () {

        $users = $this->fromDbConnection->table('isbn_users') ->get();
        foreach ($users as $user) {

            $this->toDbConnection->table('users')
                ->insert([
                    'first_name' => $user -> First_Name,
                    'last_name' => $user-> Last_Name,
                    'email' => $user -> Email,
                    'password' => $user->Password,
                    'is_locked' => $user->Activated == 'Y' ? 0 : 1,
                    'status' => 2,
                    'created_at' => $user->Registration_Date,
                    'updated_at' => $user->Last_Modified
                ]);
        }
    }
    public function getEditionValueFor($string) {
        switch ($string) {
            case '1st':
                return 'First';
            case '2nd':
                return 'Second';
            case '3rd':
                return 'Third';
            case '4th':
                return 'Fourth';
            case '5th':
                return 'Fifth';
            case '6th':
                return 'Sixth';
            case '7th':
                return 'Seventh';
            case '8th':
                return 'Eighth';
            case '9th':
                return 'Ninth';
            case '10th':
                return 'Tenth';
            case '11th':
                return 'Eleventh';
            case '12th':
                return 'Twelfth';
             case '13th':
                return 'Thirteenth';
             case '14th':
                return 'Fourteenth';
             case '15th':
                return 'Fifteenth';
             case '16th':
                return 'Sixteenth';
             case '17th':
                return 'Seventeenth';
             case '18th':
                return 'Eighteenth';
             case '19th':
                return 'Nineteenth';
             case '20th':
                return 'Twenty';
             case '21th':
                return 'Twenty first';
             case '22th':
                return 'Twenty second';
             case '23th':
                return 'Twenty third';
             case '24th':
                return 'Twenty fourth';
             case '25th':
                return 'Twenty fifth';
             case '26th':
                return 'Twenty sixth';
             case '27th':
                return 'Twenty seventh';
             case '28th':
                return 'Twenty eighth';
             case '29th':
                return 'Twenty ninth';
             case '30th':
                return 'Thirtieth';
             case '31th':
                return 'Thirty first';
             case '32th':
                return 'Thirty second';
             case '33th':
                return 'Thirty third';
             case '34th':
                return 'Thirty fourth';
             case '35th':
                return 'Thirty fifth';
             case '36th':
                return 'Thirty sixth';
             case '37th':
                return 'Thirty seventh';
             case '38th':
                return 'Thirty eighth';
             case '39th':
                return 'Thirty ninth';
             case '40th':
                return 'Fortieth';


            default:
                return ' ';
        }
    }
    public function getIsbnTypeValueFor ($string) {
        // 0 = book, 1=cassette/CD 2=Ebook, 3=Computersoftware, 4=map, 5, microfilm, 6=other
        switch ($string) {
            case 'Book':
                return 0;
            case 'Cassette/CD':
                return 1;
            case 'E-book':
                return 2;
            case 'Computer Software':
                return 3;
            case 'Map';
                return 4;
            case 'Microfilm/Microfiche':
                return 5;
            default:
                return 6;
        }
    }

    public function getMasterPublisherIds ($maps) {
       $maps = collect($maps);
       return $maps->map(function($item){
           return $item[0];
       });
    }
    protected function getRelatedPublishersId ($idMaps, $publisherID) {
        $idMaps = collect($idMaps);
        return $idMaps->first(function($item) use ($publisherID){
            return in_array($publisherID, $item);
        });
    }
    public function migratePublishers () {
        $migratedIsbnNumbers = [];

        $idMaps = include (public_path("id_maps.php"));

        $time = new Carbon();
        $filteredIds = $this -> getMasterPublisherIds ($idMaps);
        /*** Publishers table migration ****/
        $items = $this->fromDbConnection->table('publishers') ->whereIn('Publisher_ID',$filteredIds)->get();
        $itemCount = $items->count();
        $insertedIsbnApp = [];
        foreach ($items as $index=>$item) {

            $publisherId = $this->toDbConnection->table('publishers')
                ->insertGetId([
                    'title' => substr($item->Publisher_Name,0, 170),
                    'street' => $item->Publisher_Street ? $item->Publisher_Street : ' ',
                    'city' => $item->Publisher_City,
                    'phone_number' => $item->Publisher_Phone,
                    'fax_number' => $item->Publisher_Fax,
                    'email' => $item->Publisher_Email,
                    'created_by' => 1,
                    'updated_by' => 1,
                    'created_at' => $time,
                    'updated_at' => $time,
                ]);
            $this->info("Publisher number ". ( $index + 1) . "/" . $itemCount ." migration complete");
            $this->info("Migrating isbn_applications....");
            $recordedPrefixes = [];
            $relatedIds = $this->getRelatedPublishersId($idMaps, $item->Publisher_ID);
            $isbnApps  = $this->fromDbConnection->table('isbn_applications') -> whereIn('Publisher_ID', $relatedIds) -> get();

            foreach ($isbnApps as $isbnApp) {
                if( !$isbnApp->Title || $isbnApp->Application_Date == '0000-00-00' || in_array($isbnApp->Application_Number, $insertedIsbnApp) ) continue;
                $priceMatch = [];
                preg_match("/[0-9]+/",$isbnApp->Price,$priceMatch);

                $appId = $this->toDbConnection->table('isbn_applications')
                    ->insertGetId([
                        'id' => $isbnApp->Application_Number,
                        'publisher_id' => $publisherId,
                        'requested_date' => $isbnApp->Application_Date,
                        'isbn_type' => $this->getIsbnTypeValueFor($isbnApp->Publication_Type),
                        'title' => substr($isbnApp->Title,0, 100),
                        'edition' => $this->getEditionValueFor($isbnApp->Edition),
                        'subject' => substr($isbnApp->Subject, 0, 100),
                        'accession_number' => substr($isbnApp->Accession_Number, 0, 100),
                        'received_status' => $isbnApp->Received == 'R' ? 1 : 0,
                        'language' => $isbnApp->Language,
                        'type' => $isbnApp->Publication_Type !=='PB' ? 'hardbound' : 'paperbound',
                        'corporate_author' => (substr($isbnApp->Corporate_Author, 0, 100))? substr($isbnApp->Corporate_Author, 0, 100) : ' ',
                        'corporate_author_address' => substr($isbnApp->Corporate_Author_Address, 0, 100),
                        'affiliation_author_address' => substr( $isbnApp->Affiliation_Author_Address, 0, 100),
                        'year' => intval($isbnApp->Publication_Year),
                        'preliminary_page' => substr($isbnApp->Preliminary_Page, 0, 100),
                        'textual_page' => substr($isbnApp->Textual_Page, 0, 100),
                        'number_of_pages' => intval($isbnApp->Total_Pages),
                        'price' => count($priceMatch) > 0 ? $priceMatch[0] : 0,
                        'call_number' => substr($isbnApp->Call_Number, 0, 100),
                        'book_number' => substr($isbnApp->Book_Number, 0, 100),
                        'keywords' => substr( $isbnApp->Keywords, 0, 100),
                        'illustration_type' => $isbnApp->Illustration_Type ?  1 : 0,
                        'illustration_color' => $isbnApp->Illustration_Color ? 1 : 0,
                        'photo_illustration' => $isbnApp->Photos ? 1 : 0,
                        'book_cover_url' => substr($isbnApp->Book_Cover, 0, 100),
                        'deposit_slip_url' => substr($isbnApp->Deposit_Slip, 0, 100),
                        'readonly' => 0,
                        'created_by' =>1,
                        'updated_by' => 1,
                        'created_at' =>$time,
                        'updated_at' => $time,
                    ]);

                $insertedIsbnApp[] = $isbnApp->Application_Number;

                //insert author
                $author = substr($isbnApp->Author, 0, 100);
                if(strlen($author) > 0) {
                    $this->toDbConnection->table('authors') -> insert(['isbn_application_id' => $appId, 'name' => $author, 'created_at' => $time, 'updated_at' => $time]);
                }

                /*** Issued isbn *****/
                $issuedIsbns = $this->fromDbConnection -> table('isbn_issued') -> where('Application_Number', $isbnApp->Application_Number)->get();

                foreach ($issuedIsbns as $issuedIsbn) {
                    if(!$issuedIsbn -> ISBN) continue;
                    $fullIsbnNumber = substr(str_replace(' ', '',$issuedIsbn->ISBN2 ),0, 13);
                    if(!is_numeric($fullIsbnNumber)) continue;
                    if(in_array($fullIsbnNumber, $migratedIsbnNumbers)) {
                        continue;
                    }

                    //migrate prefixes
                    // remove 978- from the isbn
                    $isbn10 = preg_replace('/^978-/',"", $issuedIsbn->ISBN);
                    $isbnSplit = explode('-', $isbn10);
                    if(count($isbnSplit) == 4 ) {

                        $prefixValue = $isbnSplit[1];
                        $prefixId = null;
                        if(!in_array($prefixValue,$recordedPrefixes)){
                            $prefixId = $this->toDbConnection->table('publisher_prefixes')
                                ->insertGetId([
                                    'publisher_id' => $publisherId,
                                    'prefix' => $prefixValue,
                                    'created_by' => 1,
                                    'updated_by' => 1,
                                    'created_at' => $time,
                                    'updated_at' => $time,
                                    'effective_date' => $issuedIsbn -> Issued_Date
                                ]);
                            $recordedPrefixes["{$prefixId}"] = $prefixValue;
                        }
                        if(!$prefixId) {
                            // find id in the current recordedPrefix
                            foreach ($recordedPrefixes as $prefId => $prefixVal) {
                                if($prefixVal == $prefixValue) {
                                    $prefixId = $prefId;
                                }
                            }
                        }

                        if($prefixId) {
                            $isbnId = $this->toDbConnection->table('issued_isbns')
                                ->insertGetId([
                                    'publisher_id' => $publisherId,
                                    'isbn_application_id' => $appId,
                                    'publisher_prefix_id' =>  $prefixId, // Old isbns will not have prefix id
                                    'isbn_number' => $isbnSplit[2],
                                    'readonly' => 1,
                                    'issued_date' => $issuedIsbn->Issued_Date ? $issuedIsbn ->Issued_Date : '2008-03-04' ,
                                    'created_by' => 1,
                                    'updated_by' => 1,
                                    'created_at' => $time,
                                    'updated_at' => $time,
                                    'full_isbn_number' => $fullIsbnNumber
                                ]);
                            $migratedIsbnNumbers[] = $fullIsbnNumber;
                        }


                    }






                }
            }

        }


    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {

//        $this->makeDbConnect ('tucl_new', 'isbn_migration_db');
        $this->makeDbConnect ('origin_isbn_db','isbndb_new');

        $this->toDbConnection->table('issued_isbns')->delete();
        $this->toDbConnection->table('authors')->delete();
        $this->toDbConnection->table('isbn_applications')->delete();
        $this->toDbConnection->table('publisher_prefixes')->delete();
        $this->toDbConnection->table('publishers')->delete();
        //$this->toDbConnection->table('users')->delete();
       // $this->toDbConnection->table('authors')->delete();
       // $this->toDbConnection->table('sessions');
        $this->toDbConnection->table('user_registration_confirmation');
        try {
            DB::beginTransaction();
            $this->migrateUsers ();
             $this->migratePublishers ();
            DB::commit();

            $this->info("Migration successfully succeeded");
        }catch (\Exception $exception) {
            DB::rollBack();
            $this->error($exception->getMessage(). " File " .  $exception->getFile(). " : Line number: " . $exception->getLine());
        }


        return null;
    }


}
