<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 1/3/2017
 * Time: 10:08 PM
 */

namespace NicoSystem\Validation;

use Illuminate\Validation\Validator;

class NicoValidation extends Validator
{

    protected function replaceDigitsBetweenComposite ($message, $attribute, $rule, $parameter) {
        return str_replace(':between', implode(', ',$parameter),$message);
    }
    /**
     * Validate phone
     * @param $attribute
     * @param $value
     * @param $parameters
     * @return false|int
     */
    public function validatePhone($attribute, $value, $parameters)
    {
        /*
         * accept phone in
         * +xxxx-xxx-xxx-xxxx or
         * 00xxxx-xxx-xxx-xxxx or
         * xxx-xxx-xxxx or
         * +xxx-xxx-xxx-xxxx or
         * xxxxxxxxxx
         * (xxx)-xxx-xxxx
         */
        return preg_match('%^(?:(?:\(?(?:00|\+)([1-4]\d\d|[1-9]\d?)\)?)?[\-\.\ \\\/]?)?((?:\(?\d{1,}\)?[\-\.\ \\\/]?){0,})?$%i', $value) && strlen($value) >= 7;

    }

    /**
     * @param $attribute
     * @param $value
     * @param $parameters
     * @return bool
     */
    public function validatePassword($attribute, $value, $parameters)
    {
        return true;
    }

    /**
     * @param $attribute
     * @param $value
     * @param $parameters
     * @return bool
     */
    public function validateNotSame($attribute, $value, $parameters)
    {
        $this->requireParameterCount(1, $parameters, 'not_same');

        $other =$parameters[0];

        return $value !== $other;
    }


    public function validateDigitsBetweenComposite ($attribute, $value, $parameters, $rule) {
        if(!$value) {
            return true;
        }

        foreach ($parameters as $parameter) {

            list ($min, $max) = explode('-',$parameter);
            if($value >=intval($min) && $value <=intval($max)) {
                return true;
            }
        }
        return false;
    }


}
