<?php
/**
 * Created by PhpStorm.
 * User: Rocco
 * Date: 10/25/2018
 * Time: 3:59 PM
 */

namespace NicoSystem\Filters;

use Illuminate\Database\Eloquent\Builder;

abstract class BaseFilter
{

    protected $builder;

    public function __construct(Builder $builder)
    {
        $this->builder=$builder;
    }

    /**
     * @param $filerOptions
     * @return Builder
     */
    public function attachFilterQuery($filerOptions)
    {
        //creating the instance for filter
        foreach ($filerOptions as $key=>$value)
        {

            if(method_exists($this,$key))
            {
                call_user_func_array([$this,$key],array_filter([$value],'strlen'));
            }
        }
        return $this->builder;
    }

    /**
     * @param string $title
     */
    public function title($title='')
    {
        if($title!=='')
        {
            $this->builder->where('title','like',"%{$title}%");
        }
    }

    /**
     * @param $keyword
     * @return mixed
     */
    public abstract function keyword($keyword);

    /**
     * @param $status
     */
    public function status ($status ='') {
        if($status !='' || $status!= null) {
            $this->builder->where('status',$status);
        }
    }

}
