<?php
    /**
     * Created by PhpStorm.
     * User: Amar
     * Date: 10/18/2017
     * Time: 4:20 PM
     */

    namespace NicoSystem\Exceptions;


    class NicoException extends \RuntimeException
    {
        /**
         * @var int
         */
        protected $code = 500;
        /**
         * $response code
         * @var string
         */
        protected $respCode = "err_runtime_error";
        /**
         * @var mixed
         */
        protected $respBody = null;

        /**
         * NicoException constructor.
         *
         * @param string          $message
         * @param string          $responseCode
         * @param mixed           $respBody
         * @param int             $code
         * @param \Exception|null $previous
         */
        public function __construct($message = "", $responseCode = '',$respBody = null,$code = 0, \Exception $previous = null)
        {
            if($responseCode){
                $this->respCode = $responseCode;
            }
            $this->respBody = $respBody;
            parent::__construct($message, $code, $previous);
        }

        /**
         * @return string
         */
        public function getResponseCode(){
            return $this->respCode;
        }

        /**
         * @return mixed
         */
        public function getResponseBody(){
            return $this->respBody;
        }

        /**
         * Set response code
         * @param string|int $respCode
         * @return NicoException
         */
        public function setResponseCode($respCode){
            $this->respCode = $respCode;
            return $this;
        }

        /**
         * Set response body
         * @param mixed $respBody
         * @return mixed
         */
        public function setResponseBody($respBody){
            $this->respBody = $respBody;
            return $this;
        }

    }