<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 2/27/2017
 * Time: 5:43 PM
 */

namespace NicoSystem\Exceptions;


class DataAssertionException extends \RuntimeException
{
    protected $model;

    protected $message = "Data assertion failed";

    protected $code = 100;

    protected $dataName;


    /**
     * @param $model
     * @return $this
     */
    public function setModel($model){
        $this->model = $model;
        return $this;
    }

    /**
     * @return mixed
     */
    public function getModel(){
        return $this->model;
    }

    /**
     * @param $dataName
     * @return $this
     */
    public function setDataName($dataName)
    {
        $this->dataName = $dataName;
        $this->message = "Data assertion failed for '" . $dataName . "' for model " . get_class($this->model);
        return $this;
    }

    /**
     * @return mixed
     */
    public function getDataName(){
        return $this->dataName;
    }


}