<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 12/30/2016
 * Time: 11:38 PM
 */

namespace NicoSystem\Controllers;

use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use NicoSystem\Foundation\NicoResponseTraits;
use NicoSystem\Repositories\BaseRepository;


abstract class BaseController extends Controller
{
    use NicoResponseTraits;
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    /**
     * @var BaseRepository
     */
    protected $repository;
    /**
     * @var bool
     */
    protected $api = true;

    /**
     * Toggle publish status of a resource
     * @param Request $request
     * @param $id
     * @return  mixed
     */
    public function togglePublish(Request $request, $id) {
        return $this->responseOk( $this->repository->togglePublish($id));
    }


}