<?php
/**
 * Created by PhpStorm.
 * User: Amar
 * Date: 1/2/2017
 * Time: 10:20 PM
 */

namespace NicoSystem\Commands;


use Illuminate\Console\Command;
use Illuminate\Filesystem\Filesystem;
use Illuminate\Foundation\Application;
use Illuminate\Support\Pluralizer;
use Symfony\Component\Console\Input\InputArgument;
class ModuleGenerateCommand extends Command
{
    /**
     * The console command name.
     *
     * @var string
     */
    protected $name = 'generate:nicomodule';
    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Generate a new nico module';
    /**
     * The filesystem instance.
     *
     * @var Filesystem
     */
    protected $files;

    protected $moduleContainer;

    protected $moduleSystem;

    protected $moduleSystempath;

    protected  $app;

    protected $_modulename;

    protected $_modulenamePlural;

    protected $namespacePrefix;

    protected $namespace;

    protected $stubPath;

    protected $modulePath;

    protected $moduleStubFiles = [
        'api.stub'=>['Routes',true,'none'],/// foldername,needs pluralization,prefixed/replaced/none
        'Controller.stub'=>['Controllers',true,'prefixed'],
        'Filter.stub'=>['Filters',true,'prefixed'],
        'CreateRequest.stub'=>['Requests',false,'prefixed'],
        'DeleteRequest.stub'=>['Requests',false,'prefixed'],
        'Interface.stub'=>['Interfaces',false,'prefixed'],
        'Model.stub'=>['Database/Models',false,'replaced'],
        'ServiceProvider.stub'=>['',false,'none'],
        'Repository.stub'=>['Repositories',false,'prefixed'],
        'Request.stub'=>['Requests',false,'prefixed'],
        'UpdateRequest.stub'=>['Requests',false,'prefixed'],
        'web.stub'=>['Routes',false,'none']
    ];

    protected $systemStubFiles  = [
        'SystemModel.stub'=>['Database/Models',false,'replaced'], ////folder, needs plurization, prefixed/replaced/none
    ];

    public function __construct(Filesystem $files, Application $application)
    {
        parent::__construct();
        $this->files = $files;
        $this->app = $application;
        $this->moduleContainer = $this->app['config']->get('nicoSystem.module');
        $this->moduleSystem = $this->app['config']->get('nicoSystem.system');
        $this->namespacePrefix ='\App\\'.$this->moduleContainer;
        $this->stubPath = realpath(__DIR__ . "/../Stubs/")."/";

    }
    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function fire()
    {
        $this->makeModule();
    }

    public function handle(){
        $this->fire();
    }

    /**
     * Generate the desired migration.
     */
    protected function makeModule()
    {
        $name = ucfirst($this->argument('name'));
        $this->_modulename = Pluralizer::singular($name);
        $this->_modulenamePlural = Pluralizer::plural($name);
        $this->namespace = $this->namespacePrefix . "\\".$this->_modulenamePlural;

        if ($this->files->exists($this->modulePath = $this->getPath($this->_modulenamePlural))) {
            $this->error('Module ' . $name . '  already exists!');return;
        }
        $this->moduleSystempath = $this->getPath($this->_modulename,'system');
        $this->copyModuleStructureFromStubs();
        $this->info("Module $name successfully generated");

    }

    protected function copyModule(){
        if (!$this->files->isDirectory(dirname($this->modulePath))) {
            $this->files->makeDirectory(dirname($this->modulePath), 0777, true, true);
        }

        $this->files->copyDirectory(realpath($this->stubPath."Module"),$this->modulePath);
        $this->generateCodeFromStubs();
    }

    protected function copySystem(){
        if (!$this->files->isDirectory(dirname($this->moduleSystempath))) {
            $this->files->makeDirectory(dirname($this->moduleSystempath), 0777, true, true);
        }

        $this->files->copyDirectory(realpath($this->stubPath."System"),$this->moduleSystempath);
        $this->generateSystemCodeFromStubs();
    }
    /**
     * Build the directory for the class if necessary.
     *
     * @param  string $path
     * @return string
     */
    protected function copyModuleStructureFromStubs()
    {
        $this->copyModule();
        $this->copySystem();
    }

    /**
     * Generate Cod from stubs
     * @param $path
     */
    protected function generateCodeFromStubs(){
        foreach ($this->moduleStubFiles as $stubName=> $stubConfig){
            list($foldername,$plural,$action) = $stubConfig;
            $this->generateCodeFromStubFile($stubName,$foldername,$plural,$action);
        }
    }

    protected function generateSystemCodeFromStubs(){
        foreach ($this->systemStubFiles as $stubName=> $stubConfig){
            list($foldername,$plural,$action) = $stubConfig;
            $this->generateSystemCodeFromStubFile($stubName,$foldername,$plural,$action);
        }
    }
    protected function generateSystemCodeFromStubFile($stubName,$foldername,$plural,$action){
        $stubPath = $this->stubPath.$stubName;
        $destination = $this->moduleSystempath. "/".$foldername;
        $stub = $this->files->get($stubPath);
        //replace the placeholders in the stubs
        $name  = $plural?$this->_modulenamePlural:$this->_modulename;
        $stub = str_replace("{{routemodule}}",strtolower($this->_modulenamePlural),$stub);
        $stub = str_replace("{{module}}",$this->_modulenamePlural,$stub);
        $stub = str_replace("{module}",$this->_modulename,$stub);
        $stub = str_replace("{moduleContainer}",$this->moduleContainer,$stub);
        $stub = str_replace("{system}",$this->moduleSystem,$stub);

        $filename = str_replace(".stub",".php",$stubName);
        switch ($action){
            case 'prefixed':
                $filename = $name.$filename;
                break;
            case "replaced":
                $filename = $name.".php";
                break;
        }
        
        $this->files->put($destination."/".$filename,$stub);
    }
    /**
     * @param $modulePath
     * @param $stubName
     * @param $foldername
     * @param $plural
     * @param $action
     */
    protected function generateCodeFromStubFile($stubName,$foldername,$plural,$action){
        $stubPath = $this->stubPath.$stubName;
        $destination = $this->modulePath. "/".$foldername;
        $stub = $this->files->get($stubPath);
        //replace the placeholders in the stubs
        $name  = $plural?$this->_modulenamePlural:$this->_modulename;
        $stub = str_replace("{{routemodule}}",strtolower($this->_modulenamePlural),$stub);
        $stub = str_replace("{{module}}",$this->_modulenamePlural,$stub);
        $stub = str_replace("{module}",$this->_modulename,$stub);
        $stub = str_replace("{moduleContainer}",$this->moduleContainer,$stub);
        $stub = str_replace("{system}",$this->moduleSystem,$stub);
        $filename = str_replace(".stub",".php",$stubName);
        switch ($action){
            case 'prefixed':
                $filename = $name.$filename;
                break;
            case "replaced":
                $filename = $name.".php";
                break;
        }
        $this->files->put($destination."/".$filename,$stub);
    }

    /**
     * Get the path to where we should store the migration.
     *
     * @param  string $name
     * @param  string $type
     * @return string
     */
    protected function getPath($name,$type="module")
    {
        if($type=='module'){
            return app_path($this->moduleContainer . "/". $name);
        }
        return app_path($this->moduleSystem . "/".$name);
    }

    /**
     * @return array
     */
    protected function getArguments()
    {
        return [
            ['name', InputArgument::REQUIRED, 'The name of the module'],
        ];
    }
}