<?php
    /**
     * Created by PhpStorm.
     * User: Amar
     * Date: 11/6/2017
     * Time: 4:23 PM
     */

    namespace NicoSystem\Commands;

    use Illuminate\Console\Command;
    use Illuminate\Filesystem\Filesystem;
    use Illuminate\Foundation\Application;
    use Illuminate\Support\Pluralizer;
    use Symfony\Component\Console\Input\InputArgument;
    use Symfony\Component\Finder\SplFileInfo;

    class AngularModuleGenerateCommand extends Command
    {
        /**
         * The console command name.
         *
         * @var string
         */
        protected $name = 'generate:nicoAngularModule';
        /**
         * The console command description.
         *
         * @var string
         */
        protected $description = 'Generate a new nico angular module';
        /**
         * The filesystem instance.
         *
         * @var Filesystem
         */
        protected $files;

        protected  $app;

        protected $stubPath = "";

        protected $appPath = "";

        protected $moduleContainer = "";
        protected $modulePath = "";


        public function __construct(Filesystem $files, Application $application)
        {
            parent::__construct();
            $this->files = $files;
            $this->app = $application;
            $this->stubPath = realpath(__DIR__ . "/../Stubs/AngularApp")."/";
            $this->appPath = config('nicoSystem.angular_app_path');
            $this->moduleContainer= config('nicoSystem.angular_app_path')."/"."admin-module";

        }
        /**
         * Execute the console command.
         *
         * @return mixed
         */
        public function fire()
        {
            $this->makeModule();
            return true;
        }

        /**
         * Handle the command
         */
        public function handle(){
            $this->fire();
        }

        protected function generateModule(){

            if (!$this->files->exists($this->modulePath)) {
                $this->files->makeDirectory($this->modulePath, 0777, true, true);
            }
            $this->generateCodeFromStubs();
        }

        protected function generateCodeFromStubs(){
            $allFiles = $this->files->allFiles($this->stubPath,true);
            foreach ($allFiles as $file){
                $relativePathName = $file->getRelativePathname();

                //remove the module from relative path
                $relativePathName = substr($relativePathName,6);
                //replace the moduleName and whatever with module name and right extension
                $relativePathName = str_replace('moduleName',$this->getModuleName(),$relativePathName);
                $relativePathName = str_replace('ModuleName',ucfirst($this->getModuleName()),$relativePathName);
                $relativePathName = str_replace('.stub','.ts',$relativePathName);
                //create folder if not exist
                $paths = explode('\\',$relativePathName);
                array_pop($paths);
                $directory = implode('\\',$paths);

                if(!$this->files->isDirectory($this->modulePath.$directory)){
                    $this->files->makeDirectory($this->modulePath.$directory,0777,true,true);
                }

                //create the file to the module location
                $contents = $file->getContents();
                $contents = str_replace('{{moduleName}}',$this->getModuleName(),$contents);
                $contents = str_replace('{{ModuleName}}',ucfirst($this->getModuleName()),$contents);

                $this->files->put($this->modulePath.$relativePathName,$contents);


            }



        }

        /**
         * Make Module
         */
        protected function makeModule(){
            $moduleName = $this->getModuleName();
            if ($this->files->exists($this->modulePath = $this->getPath($moduleName))) {
                //$this->error('Module ' . $moduleName . '  already exists!');return;
            }
            $this->generateModule();

        }

        protected function getModuleName(){
            return $this->argument('name');
        }
        /**
         * @return array
         */
        protected function getArguments()
        {
            return [
                ['name', InputArgument::REQUIRED, 'The name of the module'],
            ];
        }

        /**
         * Get the path to where we should store the migration.
         *
         * @param  string $name
         * @return string
         */
        protected function getPath($name)
        {
            return $this->moduleContainer ."/".$name;
        }


    }