import {Injectable} from '@angular/core';
import {BaseService} from '../../../system/services/BaseService';
import {BasePermissionGroup} from '../../base/contituents/uac/models/BasePermissionGroup';
import {NicoHttp} from '../../../system/requests/NicoHttp';
import {environment} from '../../../../environments/environment';
import {Observable} from 'rxjs';
import {PermissionGroupActionInterface} from "../interfaces/permission-group-action.interface";
import {map} from "rxjs/operators";
import {ServerResponse} from "../../../system/responses/ServerResponse";

@Injectable({
  providedIn: 'root'
})
export class PermissionGroupListService extends BaseService implements PermissionGroupActionInterface{

  protected resourceName: string = 'permission-groups';

  protected resourceBaseUrl: string = '';

  protected resource: BasePermissionGroup;

  constructor(protected http: NicoHttp) {
    super(http, environment);
    this.resource = new BasePermissionGroup();
    this.generateResourceUrl();
  }


  public setPermissionGroup(permissionGroupId: number, userId: number): Observable<any> {
    return this.http.put(this.resourceBaseUrl + `/${permissionGroupId}/users/${userId}`,{}).pipe(map((res: ServerResponse) => {
      return true;
    }));
  }

  public removePermissionGroup(permissionGroupId: number, userId: number) {
      return this.http.delete(this.resourceBaseUrl + `/${permissionGroupId}/users/${userId}`).pipe(map((res: ServerResponse) => {
        return true;
      }));
  }
}
