import {Injectable} from "@angular/core";
import {BaseService} from "../../system/services/BaseService";
import {NicoHttp} from "../../system/requests/NicoHttp";
import {environment} from "../../../environments/environment";
import{NoticeModel} from  "../../shared/base/contituents/news/models/BaseNotice"

@Injectable()
export class PublicNoticeService extends BaseService {
  /**
   * The resource
   * @type {string}
   */
  protected resourceName: string = 'public/news';
  /**
   * Base resource url
   * @type {string}
   */
  protected resourceBaseUrl: string = '';
  /**
   *
   * @type {User}
   */
  protected resource: NoticeModel;

  /**
   * Constructor
   * @param http
   */
  public constructor(protected http: NicoHttp) {
    super(http, environment);
    this.resource = new NoticeModel();
    this.setResourceName(this.resourceName);
  }
}
