import {Injectable} from '@angular/core';
import {environment} from '../../../../../environments/environment';
import {BaseService} from '../../../../system/services/BaseService';
import {NicoHttp} from '../../../../system/requests/NicoHttp';
import {BaseUser} from '../../../../shared/base/contituents/user/models/BaseUser';

@Injectable({
  providedIn: 'root'
})

export class ResellerUsersService extends BaseService {

  /**
   * The resource
   * @type {string}
   */
  protected resourceName: string;
  /**
   * Base resource url
   * @type {string}
   */
  protected resourceBaseUrl: string = '';
  /**
   *
   * @type {User}
   */
  protected resource: BaseUser;

  protected resellerId: number;

  /**
   * Constructor
   * @param http
   */
  public constructor(protected http: NicoHttp) {
    super(http, environment);
    this.resource = new BaseUser();
  }

  /**
   * Set reseller
   * @param reseller
   */
  public setResellerId(reseller: number) {
    this.resellerId = reseller;
    this.setResourceName(`resellers/${this.resellerId}/users`);
  }

  public addUser(user: BaseUser) {
    return this.http.put(this.resourceBaseUrl + `/${user.id}`, {});
  }

  public removeUser(user: BaseUser) {
    return this.http.delete(this.resourceBaseUrl + `/${user.id}`, {});
  }

}
