import { EventEmitter, Injectable } from '@angular/core';
import { BaseService } from "../../../../system/services/BaseService";
import { NicoHttp } from "../../../../system/requests/NicoHttp";
import {RequestPublisherOwnerModel} from "../models/request-publisher-owner";
import {environment} from "../../../../../environments/environment";
import {BasePublisherInterface} from "../../../../shared/base/contituents/publisher/interfaces/BasePublisherInterface";
import {Observable} from "rxjs";

@Injectable()
export class RequestPublisherOwnerService extends BaseService {

    /**
     * The resource
     * @type {string}
     */
    protected resourceName: string = 'publisher/request-publisher-owner';
    /**
     * Base resource url
     * @type {string}
     */
    protected resourceBaseUrl: string = '';
    /**
     *
     * @type {User}
     */
    protected resource: RequestPublisherOwnerModel;

    /**
     * Constructor
     * @param http
     */
    public constructor(protected http: NicoHttp) {
        super(http, environment);
        this.resource = new RequestPublisherOwnerModel();
        this.setResourceName(this.resourceName);
    }


    // public requestPublisher(input): Observable<any> {
    //   return this.http.post(this.getBaseApiUrl() + '/publisher/request-publisher-owner', input);
    // }
    
    public acceptRequest (data): Observable<any> {
      return this.http.put(this.getBaseApiUrl() + '/publisher/request-publisher-owner/request-accept/' + data.id, null);
    }

  }


