import { EventEmitter, Injectable } from '@angular/core';
import { BaseService } from "../../../../system/services/BaseService";
import { NicoHttp } from "../../../../system/requests/NicoHttp";
import {RequestAddPublisherModel} from "../models/request-add-publisher";
import {environment} from "../../../../../environments/environment";
import {BasePublisherInterface} from "../../../../shared/base/contituents/publisher/interfaces/BasePublisherInterface";
import {BaseUserInterface} from "../../../../shared/base/contituents/user/interfaces/UserBaseInterface";
import {Observable} from "rxjs";

@Injectable()
export class RequestAddPublisherService extends BaseService {

    /**
     * The resource
     * @type {string}
     */
    protected resourceName: string = 'publisher/request-publishers-list';
    /**
     * Base resource url
     * @type {string}
     */
    protected resourceBaseUrl: string = '';
    /**
     *
     * @type {User}
     */
    protected resource: RequestAddPublisherModel;

    /**
     * Constructor
     * @param http
     */
    public constructor(protected http: NicoHttp) {
        super(http, environment);
        this.resource = new RequestAddPublisherModel();
        this.setResourceName(this.resourceName);
    }


    public requestPublisher(input: BasePublisherInterface): Observable<any> {
      return this.http.post(this.getBaseApiUrl() + '/publisher/request-publisher', input);
    }
    
    public acceptRequest (data: BasePublisherInterface ): Observable<any> {
      return this.http.put(this.getBaseApiUrl() + '/publisher/request-accept/' + data.id, null);
    }

  }


