import { EventEmitter, Injectable } from '@angular/core';
import { BaseService } from "../../../../system/services/BaseService";
import { NicoHttp } from "../../../../system/requests/NicoHttp";
import {Publisher} from "../models/Publisher";
import {environment} from "../../../../../environments/environment";
import {BasePublisherInterface} from "../../../../shared/base/contituents/publisher/interfaces/BasePublisherInterface";
import {BaseUserInterface} from "../../../../shared/base/contituents/user/interfaces/UserBaseInterface";
import {Observable} from "rxjs";
import {BasePublisherPrefix} from "../../../../shared/base/contituents/publisher/models/BasePublisherPrefix";
@Injectable()
export class PublisherPrefixService extends BaseService {

    /**
     * The resource
     * @type {string}
     */
    protected resourceName: string = 'publishers/{publisherId}/prefixes';
    /**
     * Base resource url
     * @type {string}
     */
    protected resourceBaseUrl: string = '';
    /**
     *
     * @type {User}
     */
    protected resource: BasePublisherPrefix;

    /**
     * Constructor
     * @param http
     */
    public constructor(protected http: NicoHttp) {
        super(http, environment);
        this.resource = new BasePublisherPrefix();
        this.setResourceName(this.resourceName);
    }

}
