import { CommonModule } from '@angular/common';
import { NgModule } from '@angular/core';

import { SharedModule } from '../../../shared/shared.module';
import { PublishersRoutingModule } from './publishers-routing.module';
import { RequestPublisherRoutingModule } from './request-publisher-routing.module';
import { PublishersComponent } from './publishers.component';
import { PublisherService } from './services/publisher.service';
import {PublishersListComponent} from "./components/publisher-list/publishers-list.component";
import {AddPublisherComponent} from "./components/add-publisher/add-publisher.component";
import {PublisherViewComponent} from "./components/publisher-view/publisher-view.component";
import {PublisherShowComponent} from "./components/publisher-view/pages/show/publisher.show.component";
import {PrefixesComponent} from "./components/publisher-view/pages/prefixes/prefixes.component";
import {PublisherPrefixService} from "./services/publisher-prefix.service";
import {RequestAddPublisherService} from "./services/request-add-publisher.service";
import {RequestPublisherOwnerService} from "./services/request-publisher-owner.service";
import {AddPrefixComponent} from "./components/publisher-view/pages/prefixes/components/add-prefix.component";
//import { RequestPublisherComponent } from './components/request-publisher/request-publisher.component';
import { RequestAddPublisherComponent } from './components/request-add-publisher/request-add-publisher.component';
import { ListRequestOwnerComponent } from './components/list-request-owner/list-request-owner.component';
import { ViewRequestPublisherComponent } from './components/view-request-publisher/view-request-publisher.component';
import { ListRequestPublisherComponent } from './components/list-request-publisher/list-request-publisher.component';
import { AssignPublisherOwnerComponent } from './components/assign-publisher-owner/assign-publisher-owner.component';

@NgModule({
  imports: [CommonModule, PublishersRoutingModule, RequestPublisherRoutingModule, SharedModule.forRoot()],
  declarations: [PublishersComponent, PublishersListComponent, AddPublisherComponent,
    PublisherShowComponent,
    PrefixesComponent,
    AddPrefixComponent,
    PublisherViewComponent,
    //   RequestPublisherComponent,
    RequestAddPublisherComponent,
    ListRequestOwnerComponent,
    ViewRequestPublisherComponent,
    ListRequestPublisherComponent,
    AssignPublisherOwnerComponent],
  exports: [],
  entryComponents: [AddPublisherComponent, AddPrefixComponent, AssignPublisherOwnerComponent],
  providers: [PublisherService, PublisherPrefixService, RequestAddPublisherService, RequestPublisherOwnerService]
})
export class PublishersModule { }
