
import { Component, Injector, OnDestroy, OnInit } from '@angular/core';
import { PublisherService } from './services/publisher.service';
import {BaseComponent} from "../../../system/controllers/BaseComponent";
import {RouterOutlet} from "@angular/router";
import {slideInAnimation} from "../../../system/animations";


@Component({
    //moduleId: module.id,
    selector: 'app-publishers',
    templateUrl: 'publishers.component.html',
    styleUrls: [],
    animations: [slideInAnimation]

})
export class PublishersComponent extends BaseComponent implements OnInit, OnDestroy {


    constructor(injector: Injector, public service: PublisherService) {
        super(injector);

    }

    /**
     * Get the names OnInit
     */
    ngOnInit() {
        this.setPageTitle('Publishers');
    }

    /**
     *  the Method that is called after route param is initialized
     *  If you need to grab something from route and then initialize component. Define them here.
     *  Note, this method will be called every-time if url is changed. So use it wisely.
     */
    public onRouteParamInitialized() {

    }

    prepareRoute(outlet: RouterOutlet) {
        return outlet && outlet.activatedRouteData;
    }

}

