import {NgModule} from '@angular/core';
import {RouterModule} from '@angular/router';
import {PublishersComponent} from './publishers.component';
import {PublishersListComponent} from "./components/publisher-list/publishers-list.component";
import {PublisherViewComponent} from "./components/publisher-view/publisher-view.component";
import {PublisherShowComponent} from "./components/publisher-view/pages/show/publisher.show.component";
import {PrefixesComponent} from "./components/publisher-view/pages/prefixes/prefixes.component";
import {RequestAddPublisherComponent} from "./components/request-add-publisher/request-add-publisher.component";
import {ListRequestPublisherComponent} from "./components/list-request-publisher/list-request-publisher.component";
import {ViewRequestPublisherComponent} from "./components/view-request-publisher/view-request-publisher.component";
import {ListRequestOwnerComponent} from "./components/list-request-owner/list-request-owner.component";

@NgModule({
  imports: [
    RouterModule.forChild([
      {
        path: '',
        component: PublishersComponent,
        children: [
          {
            path: '',
            component: PublishersListComponent,
          },
          {
            path: 'request-publisher',
            component:RequestAddPublisherComponent 
          },
          {
            path: 'list-request-publisher',
            component:ListRequestPublisherComponent 
          },
          {
            path: 'request-publisher/:id/show',
            component: ViewRequestPublisherComponent,
          },
          {
            path: 'list-request-owner',
            component: ListRequestOwnerComponent,
          },
          {
            path: ':id',
            component: PublisherViewComponent,
            data: {animation: 'default'},
            children: [
              {
                path: 'show',
                component: PublisherShowComponent
              },
              {
                path: 'prefixes',
                component: PrefixesComponent
              }
            ]
          },
        ]
      },
    ]),

  ],
  exports: [RouterModule]
})
export class PublishersRoutingModule {
}
