import { BaseComponent } from "../../../../../system/controllers/BaseComponent";
import { Component, Injector, OnInit } from "@angular/core";
import { RequestAddPublisherModel } from "../../models/request-add-publisher";
import { RequestAddPublisherService } from "../../services/request-add-publisher.service";

@Component({
  selector: 'app-view-request-publisher',
  templateUrl: './view-request-publisher.component.html',
  // styleUrls: ['./view-request-publisher.component.scss']
})
export class ViewRequestPublisherComponent extends BaseComponent implements OnInit {
  /**
   * Model
   */
  public model: RequestAddPublisherModel;

  /**
   * service
   */
  public service: RequestAddPublisherService;

  constructor(private injector: Injector) {
    super(injector);
    this.service = injector.get(RequestAddPublisherService);
  }

  ngOnInit() {
    super.ngOnInit();
  }

  /**
   * On route param initialized hook
   */
  onRouteParamInitialized() {
    this.getResource();

  }

  /**
   * Get the resource
   */
  public getResource() {
    const subscription = this.activatedRoute.params.subscribe((params: any) => {
      const spinner = this.ajaxSpinner.showSpinner();
      const fetchSubscription = this.service.find(params.id, { params: this.urlParams }).subscribe((item: RequestAddPublisherModel) => {
        this.setPageTitle('mod_manage.mod_publishers.edit_page_title', item.title);
        this.model = item;
        spinner.hide();
        fetchSubscription.unsubscribe();
        subscription.unsubscribe();
      }, () => {
        spinner.hide();
      });
    });

  }

  public requestAccetp(item: any) {
    this.appService.showConfirmDialog({
      message: "Are you sure you want to accept the request?",
      onConfirm: () => {
        const spinner = this.ajaxSpinner.showSpinner();
        const subscription = this.service.acceptRequest(item).subscribe(() => {
          if (subscription) {
            this.showSuccessToast('Request has been successfully accepted.');
            subscription.unsubscribe();
            spinner.hide();
          }
          this.router.navigate(['/manage/publishers/list-request-publisher']);
        }, () => {
          if (subscription) {
            subscription.unsubscribe();
            spinner.hide();
          }
        });
      }
    }
    )
  };
}

