import {Component, Injector, OnInit} from "@angular/core";
import {AbstractNicoModalComponent} from "../../../../../../../../system/components/modal/AbstractNicoModalComponent";
import {Validators} from "@angular/forms";
import {Observable} from "rxjs";
import {PublisherPrefixService} from "../../../../../services/publisher-prefix.service";
import * as moment from "moment";
import {environment} from "../../../../../../../../../environments/environment";

@Component ({
  selector: 'app-publisher-add-prefix',
  templateUrl: './add-prefix.component.html',
})
export class AddPrefixComponent extends AbstractNicoModalComponent implements OnInit {

  protected busySaving = false;

  public formId = "add-publisher-prefix-form";

  public modalTitle = "Add a new prefix";

  public isbnAddOn: string = null;

  public countryPrefix: any = null;

  constructor(injector: Injector) {
    super(injector);
    this.service = injector.get(PublisherPrefixService);
    this.isbnAddOn = environment.country_isbn_identifier;
    this.countryPrefix = ['99933', '99946', '978-9937'];
  }

  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle("Add prefix");
    if (this.data.model) {
      this.setPageTitle("Edit prefix");
    }
    this.formGroup = this.formBuilder.group({
      prefix: ['', Validators.compose([Validators.required])],
      effective_date: ['', Validators.compose([Validators.required])],
      country_prefix:['', Validators.compose([Validators.required])]
    });
    if (this.data.model) {
      const patch: any = {};
      patch.prefix = this.data.model.prefix;
      patch.country_prefix = this.data.model.country_prefix;
      if (this.data.model.effective_date) {
        patch.effective_date = this.data.model.effective_date.format('YYYY-MM-DD');
      }

      this.formGroup.patchValue(patch);
      this.modalTitle = "Edit prefix";
    }
  }

  /**
   * Save the form data
   */
  public save (): Observable<any> {
    if (this.busySaving) {
      return;
    }
    const spinner = this.ajaxSpinner.showSpinner();
    this.busySaving = true;
    const data: any = this.formGroup.value;
    data.effective_date = moment(data.effective_date).format('YYYY-MM-DD');
    this.service.save(data, this.data.model ? this.data.model.id : null).subscribe(() => {
      spinner.hide();
      this.busySaving = false;
      this.okayCompleteListener();
      this.dismisser();
      if (this.data.model) {
        this.showSuccessToast("The selected prefix has been updated successfully.");
      } else {
        this.showSuccessToast("A new prefix has been added successfully.");
      }
    }, (response: any) => {
      spinner.hide();
      this.busySaving = false;
      if (!response.status.messageShown) {
        this.showErrorToast(response.status.message);
      }
      if (response.status.statusCode === 417) {
        this.validationMessenger.attach(this.formId, response.body);
      }

    });

  }

  /**
   * Cancel form
   */

  public cancel() {
    this.dismisser();
  }


}
