import {Component, Injector, OnInit, Input} from '@angular/core';
import {BaseComponent} from '../../../../../system/controllers/BaseComponent';
import {PublisherService} from '../../services/publisher.service';
import {AddPublisherComponent} from "../add-publisher/add-publisher.component";
import {AssignPublisherOwnerComponent} from "../assign-publisher-owner/assign-publisher-owner.component";
import {Publisher} from "../../models/Publisher";
import {
  ActionFlyMenuOptionsInterface,
  FlyMenuActionEnum,
  FlyMenuItemInterface
} from "../../../../../system/components/action-fly-menu/action-fly-menu.component";

@Component({
  selector: 'app-videos-list',
  templateUrl: './publishers-list.component.html',
})
export class PublishersListComponent extends BaseComponent implements OnInit {

    protected permissionGrpId = (this.authUser.permissionGroups.all()[0]).perm_grp_id;
  protected admin = [1,2];

  @Input() isAdmin:boolean;

  public extraFlyMenuItem: FlyMenuItemInterface[] = [{
    label: 'More ...',
    name: 'showMore',
    active: true
  }];

  flyMenuOptions: ActionFlyMenuOptionsInterface;

  constructor(
    injector: Injector,
    protected service: PublisherService) {
    super(injector);
  }

  protected setFlyMenu () {
    this.flyMenuOptions = {
      disableRemoveItem: !this.authUser.can('publishers.delete'),
      disableStatusItem: true,
      disableEditItem: !this.authUser.can('publishers.update')
    };
  }

  /**
   *  on init lifecycle hook
   */
   ngOnInit() {
    this.isAdmin = (this.admin).includes(this.permissionGrpId);
    super.ngOnInit();
    this.setPageTitle('mod_manage.mod_publishers.page_title');
    this.getList();
    this.setFlyMenu();
  }

  public editItem(item: Publisher) {
    this.openCreateModel(item);
  }

  public onFlyMenuAction(evt: FlyMenuActionEnum | any, item: any) {
    super.onFlyMenuAction(evt, item);
    if (evt === 'showMore') {
      this.router.navigate(['/manage/publishers/' + item.id + '/show']);
    }
  }

  /**
   * Edit item
   * @param item
   */
  public openCreateModel(item?: Publisher) {
    this.nicoCtrl.create(AddPublisherComponent, {
      htmlTemplateAsIs: true,
      data: {model: item},
      modalClass: 'custom-modal custom-modal-md',
      onOkayProcessComplete: () => {
        this.getList();
      }
    }).present();
  }

  public assignOwnereModel(item?: Publisher) {
    this.nicoCtrl.create(AssignPublisherOwnerComponent, {
      htmlTemplateAsIs: true,
      // data: {model: item},
      modalClass: 'custom-modal custom-modal-md',
      onOkayProcessComplete: () => {
        //this.getList();
      }
    }).present();
  }
}
