import {Component, Injector, OnDestroy, OnInit} from '@angular/core';
import {BaseComponent} from '../../../../../system/controllers/BaseComponent';
import {RequestAddPublisherService} from '../../services/request-add-publisher.service';
import {NewUserComponent} from '../../../../../shared/new-user-component/new-user.component';
import {StatusLabelConfig} from '../../../../../system/components/nico-status/nico-status.component';
import {StatusEnum} from '../../../../../system/enums/status.enum';
import {Collection} from '../../../../../system/utilities/Collection';

@Component({
  selector: 'app-list-request-publisher',
  templateUrl: './list-request-publisher.component.html'
})

export class ListRequestPublisherComponent extends BaseComponent implements OnInit, OnDestroy {

  protected currentService: RequestAddPublisherService;


  protected statusLabelConfig: Collection<StatusLabelConfig>;

  /**
   * Constructor
   * @param injector
   * @param service
   */
  constructor(injector: Injector, protected service: RequestAddPublisherService) {
    super(injector);
  }

  /**
   * On init hook
   */
  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle('mod_manage.mod_publishers.requested_publishers');
    this.getList();
    // this.statusLabelConfig = new Collection([
    //   {status: StatusEnum.Unpublished, value: 'mod_commons.inactive_label'},
    //   {status: StatusEnum.Published, value: 'mod_commons.active_label'}
    // ]);
  }

  /**
   * Add new item
   */
  public newItem() {
    this.currentService = this.service;
    this.nicoCtrl.create(NewUserComponent, {
      htmlTemplateAsIs: true,
      data: {service: this.currentService},
      modalClass: 'custom-modal custom-modal-540',
      onOkayProcessComplete: () => {
        this.getList();
      },
      onDestroy: () => {
        this.setPageTitle('mod_manage.mod_users.page_title');
      },
    }).present();
  }
}
