import { Component, Injector, OnDestroy, OnInit, TemplateRef, ViewChild } from '@angular/core';
import { NicoModalController } from 'src/app/system/components/modal/NicoModalController';
import { AbstractNicoModalComponent } from "../../../../../system/components/modal/AbstractNicoModalComponent";
import { AdvancedSelectConfigInterface } from "../../../../../system/components/advanced-select/advanced-select.component";
import { FormGroup, Validators } from '@angular/forms';
import { PublisherService } from '../../services/publisher.service';
import { Publisher } from "../../models/Publisher";
import { User } from '../../../me/models/User';
import { Spinner } from "../../../../../system/services/AjaxSpinner";

@Component({
  selector: 'app-assign-publisher-owner',
  templateUrl: './assign-publisher-owner.component.html',
  styleUrls: []
})
export class AssignPublisherOwnerComponent extends AbstractNicoModalComponent implements OnInit, OnDestroy {

  /**
   * The id for video add form
   * @var string
   */
  protected busySaving = false;

  public formId = "assign-publisher-owner-form";

  public formGroup: FormGroup;

  public modalTitle = "Assign Publiser Owner";

  public isbnAddOn: string = null;

  public publisherFetchUrl = "";

  public config: AdvancedSelectConfigInterface = {};

  public publisherModel;

  protected dismisser: Function;

  public model: Publisher;

  public service: PublisherService;

  protected user: User;
  /**
   * Constructor
   * @param injector
   * @param modalController
   */
  constructor(injector: Injector, protected modalController: NicoModalController) {
    super(injector);
    this.service = injector.get(PublisherService);
  }

  @ViewChild('publisherSelectItemTemplate') publisherSelectItemTemplate: TemplateRef<any>;
  @ViewChild('emptySelectionTemplate') publisherEmptyItemTemplate: TemplateRef<any>;

  public ngOnInit() {
    super.ngOnInit();
    // this.setPageTitle('mod_manage.mod_publishers.add_page_title');
    // this.modalTitle = 'mod_manage.mod_publishers.add_page_title';
    this.publisherFetchUrl = this.publisherFetchUrl = this.service.getBaseApiUrl() + '/publishers';
    this.setAdvSelectConfig();

    this.formGroup = this.formBuilder.group({
      publisher: ['', Validators.compose([Validators.required])]
    });

  }

  protected setAdvSelectConfig() {
    this.config.itemTemplate = this.publisherSelectItemTemplate;
    this.config.equalityCheckProperty = 'id';
    this.config.actionButtonEnabled = false;
    this.config.disableEmptyField = false;
    this.config.selectInfoLabel = "Select publisher";
    this.config.emptySelectionTemplate = this.publisherEmptyItemTemplate;
  }

  /**
   * On form submit
   */
  public save(): any {

    this.user = <User>this.session.getAuthUser();
    const data = {
      publisher: this.formGroup.value.publisher.id,
      user: this.user.id
    };
    const spinner: Spinner = this.ajaxSpinner.showSpinner();
    this.service.requestPublisherOwnership(data)
      .subscribe(() => {
        spinner.hide();
        this.showSuccessToast('Request has been sent, you will be contacted soon.');
        //this.formGroup.reset();
        this.dismisser();
      }, () => {
        spinner.hide();
      });

  }

  /**
   * On cancle
   */

  // public cancel() {
  //  // this.formGroup.reset();
  //   this.dismisser();
  // }

  public onPublisherChange() {
//     if (this.publisherModel) {
//       this.urlParams.publisher = this.publisherModel.id;
//     } else {
//       delete this.urlParams.publisher;
//     }
//     this.getList();
  }
}
