"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.NoticeService = void 0;
var core_1 = require("@angular/core");
var BaseService_1 = require("../../../../system/services/BaseService");
var notice_1 = require("../models/notice");
var environment_1 = require("../../../../../environments/environment");
var NoticeService = /** @class */ (function (_super) {
    __extends(NoticeService, _super);
    /**
     * Constructor
     * @param http
     */
    function NoticeService(http) {
        var _this = _super.call(this, http, environment_1.environment) || this;
        _this.http = http;
        /**
         * The resource
         * @type {string}
         */
        _this.resourceName = 'notices';
        /**
         * Base resource url
         * @type {string}
         */
        _this.resourceBaseUrl = '';
        _this.resource = new notice_1.NoticeModel();
        _this.setResourceName(_this.resourceName);
        return _this;
    }
    NoticeService.prototype.createNotice = function (input) {
        return this.http.post(this.getBaseApiUrl() + '/notices/create-notice', input);
    };
    NoticeService.prototype["delete"] = function (data) {
        return this.http["delete"](this.getBaseApiUrl() + '/notices/' + data.id, null);
    };
    NoticeService = __decorate([
        core_1.Injectable()
    ], NoticeService);
    return NoticeService;
}(BaseService_1.BaseService));
exports.NoticeService = NoticeService;
