"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
exports.__esModule = true;
exports.NoticeViewComponent = void 0;
var core_1 = require("@angular/core");
var BaseComponent_1 = require("../../../../../system/controllers/BaseComponent");
var NoticeViewComponent = /** @class */ (function (_super) {
    __extends(NoticeViewComponent, _super);
    /**
     * Constructor
     * @param injector
     * @param modalController
     */
    function NoticeViewComponent(injector, service, authService) {
        var _this = _super.call(this, injector) || this;
        _this.service = service;
        _this.authService = authService;
        return _this;
    }
    /**
     *  Oninit lifecycle hook
     */
    NoticeViewComponent.prototype.ngOnInit = function () {
        _super.prototype.ngOnInit.call(this);
        this.setPageTitle('List Notice');
        this.getList();
    };
    NoticeViewComponent.prototype["delete"] = function (item) {
        var _this = this;
        this.appService.showConfirmDialog({
            message: "Are you sure you want to delete?",
            onConfirm: function () {
                var spinner = _this.ajaxSpinner.showSpinner();
                var subscription = _this.service["delete"](item).subscribe(function () {
                    if (subscription) {
                        _this.showSuccessToast('Request has been successfully deleted.');
                        subscription.unsubscribe();
                        spinner.hide();
                    }
                    _this.router.navigate(['/manage/notices']);
                }, function () {
                    if (subscription) {
                        subscription.unsubscribe();
                        spinner.hide();
                    }
                });
            }
        });
    };
    NoticeViewComponent.prototype.editNotice = function (item) {
        console.log('d');
        this.router.navigate(['manage/notices/edit/' + item.id]);
    };
    NoticeViewComponent = __decorate([
        core_1.Component({
            selector: 'app-notice-view',
            templateUrl: './notice-view.component.html'
        })
    ], NoticeViewComponent);
    return NoticeViewComponent;
}(BaseComponent_1.BaseComponent));
exports.NoticeViewComponent = NoticeViewComponent;
