import { Component, Injector, OnDestroy, OnInit, } from '@angular/core';
import { FormGroup, Validators } from '@angular/forms';
import { BaseComponent } from "../../../../../system/controllers/BaseComponent";
import { AuthService } from '../../../../../shared/auth/services/auth.service';
import { Spinner } from "../../../../../system/services/AjaxSpinner";
import { ServerResponse } from "../../../../../system/responses/ServerResponse";
import { NoticeService } from '../../services/notice.service';
import { NoticeModel } from '../../models/notice';

@Component({
  selector: 'app-notice-create',
  templateUrl: './notice-create.component.html',
  styleUrls: ['./notice-create.component.scss']
})
export class NoticeCreateComponent extends BaseComponent implements OnInit {

  /**
   * The id for video add form
   * @var string
   */
  public formId: string = "add-notice-form";

  public noticeFormGroup: FormGroup;

  protected busy: boolean;
  /**
   * Constructor
   * @param injector
   * @param modalController
   */
  constructor(injector: Injector, protected service: NoticeService, protected authService: AuthService) {
    super(injector);
  }

  /**
   *  Oninit lifecycle hook
   */
  public ngOnInit() {
    super.ngOnInit();
    this.setPageTitle('Create Notice');
    this.initRequestForm();
  }

  protected initRequestForm() {
    this.noticeFormGroup = this.formBuilder.group({
      title: ['', Validators.required],
      body: ['', Validators.required]
    });
  }
  /**
   * On form submit
   */
  public save(): any {
    if (this.busy) {
      return;
    }
    this.busy = true;
    const spinner: Spinner = this.ajaxSpinner.showSpinner();
    this.service.save(this.noticeFormGroup.value, this.model ? this.model.id : null, null, false)
      .subscribe((res: any) => {
        this.busy = false;
        spinner.hide();
        this.showSuccessToast('Notice has been saved.');

        this.router.navigate(['/manage/notices/']);
      }, (d: ServerResponse) => {
        this.busy = false;
        spinner.hide();

        if (d.status.statusCode === 417) {
          this.validationMessenger.attach(this.formId, d.body);
        }
      });
  }

  onRouteParamInitialized() {
    super.onRouteParamInitialized();
    this.setModelIfEditPage();
  }

  protected setModelIfEditPage() {
    if (this.routeParams.get('id')) {
      const spinner = this.ajaxSpinner.showSpinner();
      this.service.find(this.routeParams.get('id'))
        .subscribe((model: NoticeModel) => {
          spinner.hide();
          this.model = model;

          this.noticeFormGroup.patchValue(this.model);
          this.pageTitle.setTitle('Edit Notice');

        }, (error: ServerResponse) => {
          spinner.hide();
          this.router.navigate(['manage/notices']);
        });
    }

}
}