import {Component, Injector, OnInit, TemplateRef, ViewChild} from "@angular/core";
import {BaseComponent} from "../../../../../system/controllers/BaseComponent";
import {IsbnIssuedService} from "../../services/isbn-issued.service";
import {
  FlyMenuActionEnum,
} from "../../../../../system/components/action-fly-menu/action-fly-menu.component";
import {BaseResourceInterface} from "../../../../../system/datamodels/BaseResourceInterface";
import {AdvancedSelectConfigInterface} from "../../../../../system/components/advanced-select/advanced-select.component";
import {IsbnIssueModalComponent} from "../../../../../shared/isbn-issue-modal/isbn-issue-modal.component";
import {environment} from "../../../../../../environments/environment";
import {AuthorsListComponent} from "../../../../../shared/authors-list-component/authors-list.component";

@Component({
  selector: 'app-isbn-issued-list',
  templateUrl: './isbn-issued-list.component.html'
})
export class IsbnIssuedListComponent extends BaseComponent implements  OnInit {

  public publisherFetchUrl = "";

  @ViewChild('publisherSelectItemTemplate') publisherSelectItemTemplate: TemplateRef<any>;
  @ViewChild('emptySelectionTemplate') publisherEmptyItemTemplate: TemplateRef<any>;
  /**
   * @var config
   */
  public config: AdvancedSelectConfigInterface = {};
  public publisherModel;

  constructor (injector: Injector) {
    super(injector);
    this.service = injector.get(IsbnIssuedService);
  }

  ngOnInit(): void {
    super.ngOnInit();
    this.pageTitle.setTitle("Issued ISBNs");
    this.loadList ();
    this.publisherFetchUrl = this.publisherFetchUrl = this.service.getBaseApiUrl() + '/publishers';
    this.setAdvSelectConfig();
  }

  protected setAdvSelectConfig() {
    this.config.itemTemplate = this.publisherSelectItemTemplate;
    this.config.equalityCheckProperty = 'id';
    this.config.actionButtonEnabled = false;
    this.config.disableEmptyField = false;
    this.config.selectInfoLabel = "Select publisher";
    this.config.emptySelectionTemplate = this.publisherEmptyItemTemplate;
  }

  protected loadList () {
    this.getList().subscribe(() => {
      for (let i = 0; i < this.items.length; i++ ) {
        // tslint:disable-next-line:triple-equals
        if (this.items.getItem(i).readonly != 1) {
          this.items.getItem(i).flyMenuAddOn = [{name: 'commit', label: 'Commit', active: true, }];
        }
      }
    });
  }

  /**
   * Edit the item
   * @param item
   */
  public editItem(item: any) {
    this.nicoCtrl.create(IsbnIssueModalComponent, {
      htmlTemplateAsIs: true,
      data: {application: item, isbn: item.issued_isbn, isbnAddOn: environment.country_isbn_identifier},
      onOkayProcessComplete: ( model: any, message: any) => {
        this.showSuccessToast(message);
        this.loadList();
      }
    }).present();
  }

  onFlyMenuAction(evt: FlyMenuActionEnum | any, item: any) {
    super.onFlyMenuAction(evt, item);
    if (evt === 'mark_as_received') {
      const subscription = (<IsbnIssuedService> this.service).commit(item).subscribe(() => {
        if (subscription) {
          subscription.unsubscribe();
        }
        this.loadList();
      }, ( ) => {
        if (subscription) {
          subscription.unsubscribe();
        }
      });
    }
  }

  public onPublisherChange () {
    if (this.publisherModel) {
      this.urlParams.publisher = this.publisherModel.id;
    } else {
      delete this.urlParams.publisher;
    }
    this.loadList();
  }

  destroy(item: any) {
    super.destroy(item.issued_isbn);
  }

  public authorListShowMore (item: any) {
    this.nicoCtrl.create(AuthorsListComponent, {
      data: {items: item.authors},
      htmlTemplateAsIs: true
    }).present();
  }

}
