import {Component, Injector} from "@angular/core";
import {BaseComponent} from "../../../../../system/controllers/BaseComponent";
import {IsbnApplicationService} from "../../../../../shared/services/isbn-application.service";
import {AppLanguageProviderService} from "../../../../../shared/services/app-language-provider.service";
import {IsbnApplication} from "../../models/IsbnApplication";
import {ServerResponse} from "../../../../../system/responses/ServerResponse";
import { Helper } from "src/app/system/utilities/Helper";

@Component({
  selector: 'app-isbn-application-show',
  templateUrl: './isbn-application-show.component.html'
})
export class IsbnApplicationShowComponent extends BaseComponent {
  constructor(injector: Injector) {
    super(injector);
    this.service = injector.get(IsbnApplicationService);
  }

  public onRouteParamInitialized() {
    super.onRouteParamInitialized();
    this.getItem();
  }

  protected getItem() {
    if (this.routeParams.get('id')) {
      const spinner = this.ajaxSpinner.showSpinner();
      this.service.find(this.routeParams.get('id'))
        .subscribe((model: IsbnApplication) => {
          spinner.hide();
          this.model = model;
        }, (error: ServerResponse) => {
          spinner.hide();
          this.router.navigate(['manage/isbn-applications']);
        });
    }

  }

  public getBack()
  {
    Helper.setStorage('getFiltered',true);
    this.router.navigate(['manage/isbn-applications']);
  }

}
